//
//  AddPersonViewController.m
//  Boosting Data Access in Table Views
//
//  Created by Vandad Nahavandipoor on 23/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "AddPersonViewController.h"
#import "Person.h"
#import "Boosting_Data_Access_in_Table_ViewsAppDelegate.h"

@implementation AddPersonViewController

@synthesize textFieldFirstName;
@synthesize textFieldLastName;
@synthesize textFieldAge;
@synthesize barButtonAdd;

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
  self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
  if (self) {
    // Miejsce na kod inicjalizacyjny.
  }
  return self;
}

- (void) createNewPerson:(id)paramSender{
  
  Boosting_Data_Access_in_Table_ViewsAppDelegate *appDelegate = 
    (Boosting_Data_Access_in_Table_ViewsAppDelegate *)
      [[UIApplication sharedApplication] delegate];
  
  NSManagedObjectContext *managedObjectContext = 
    appDelegate.managedObjectContext;
  
  Person *newPerson = 
  [NSEntityDescription insertNewObjectForEntityForName:@"Person"
                                inManagedObjectContext:managedObjectContext];
  
  if (newPerson != nil){
    
    newPerson.firstName = self.textFieldFirstName.text;
    newPerson.lastName = self.textFieldLastName.text;
    newPerson.age = [NSNumber numberWithInteger:
                     [self.textFieldAge.text integerValue]];
    
    NSError *savingError = nil;
    
    if ([managedObjectContext save:&savingError]){
      [self.navigationController popViewControllerAnimated:YES];
    } else {
      NSLog(@"Nie udało się zapisać kontekstu obiektu zarządzanego.");
    }
    
  } else {
    NSLog(@"Nie udało się utworzyć nowego obiektu.");
  }
  
}

- (void)didReceiveMemoryWarning
{
  // Usunięcie widoków, które nie posiadają widoku nadrzędnego.
  [super didReceiveMemoryWarning];
  
  // Usunięcie wszelkich buforowanych danych, obrazów itd., które nie są obecnie używane.
}

#pragma mark - Cykl życiowy widoku


- (void)viewDidLoad{
  [super viewDidLoad];
  
  self.title = @"Nowa osoba";
  
  CGRect textFieldRect = CGRectMake(20.0f, 
                                    20.0f, 
                                    self.view.bounds.size.width - 40.0f, 
                                    31.0f);
  
  self.textFieldFirstName = [[UITextField alloc] initWithFrame:textFieldRect];
  self.textFieldFirstName.placeholder = @"Imię";
  self.textFieldFirstName.borderStyle = UITextBorderStyleRoundedRect;
  self.textFieldFirstName.autoresizingMask = UIViewAutoresizingFlexibleWidth;
  self.textFieldFirstName.contentVerticalAlignment = 
    UIControlContentVerticalAlignmentCenter;
  [self.view addSubview:self.textFieldFirstName];
  
  textFieldRect.origin.y += 37.0f;
  self.textFieldLastName = [[UITextField alloc] initWithFrame:textFieldRect];
  self.textFieldLastName.placeholder = @"Nazwisko";
  self.textFieldLastName.borderStyle = UITextBorderStyleRoundedRect;
  self.textFieldLastName.autoresizingMask = UIViewAutoresizingFlexibleWidth;
  self.textFieldLastName.contentVerticalAlignment = 
    UIControlContentVerticalAlignmentCenter;
  [self.view addSubview:self.textFieldLastName];
  
  textFieldRect.origin.y += 37.0f;
  self.textFieldAge = [[UITextField alloc] initWithFrame:textFieldRect];
  self.textFieldAge.placeholder = @"Wiek";
  self.textFieldAge.borderStyle = UITextBorderStyleRoundedRect;
  self.textFieldAge.autoresizingMask = UIViewAutoresizingFlexibleWidth;
  self.textFieldAge.keyboardType = UIKeyboardTypeNumberPad;
  self.textFieldAge.contentVerticalAlignment = 
    UIControlContentVerticalAlignmentCenter;
  [self.view addSubview:self.textFieldAge];
  
  self.barButtonAdd = 
  [[UIBarButtonItem alloc] initWithTitle:@"Dodaj"
                                   style:UIBarButtonItemStylePlain
                                  target:self
                                  action:@selector(createNewPerson:)];
  [self.navigationItem setRightBarButtonItem:self.barButtonAdd
                                    animated:NO];
  
}

- (void)viewDidUnload{
  [super viewDidUnload];
  self.textFieldFirstName = nil;
  self.textFieldLastName = nil;
  self.textFieldAge = nil;
  self.barButtonAdd = nil;
}

- (void) viewDidAppear:(BOOL)paramAnimated{
  [super viewDidAppear:paramAnimated];
  [self.textFieldFirstName becomeFirstResponder];
}

- (BOOL)shouldAutorotateToInterfaceOrientation
        :(UIInterfaceOrientation)interfaceOrientation{
  return YES;
}

@end
